#include <PalmOS.h>
#include <PceNativeCall.h>
#include <VfsMgr.h>



inline UInt32 swap32(UInt32 val){
	
	return 	((val >> 24) & 0x00FF) | 
			((val >>  8) & 0xFF00) | 
			((val & 0xFF00) <<  8) |
			((val & 0x00FF) << 24);
	
}

inline void* loadImage(){
	
	UInt32 volIter = vfsIteratorStart;
	UInt16 volRef;
	void* kernel = NULL;
	UInt8* ptr;
	UInt32 size, read;
	FileRef file;
	
	
	while(volIter != vfsIteratorStop){
		
		if(errNone == VFSVolumeEnumerate(&volRef, &volIter)){
			
			if(errNone == VFSFileOpen(volRef, "/rom.bin", vfsModeRead, &file)){
				
				if(errNone == VFSFileSize(file, &size) && size != 0){
					
					if(kernel = MemChunkNew(0, size + 4 + 256 /* see arm code as to why this is */, 0x1200)){
						
						ptr = kernel;
						*(UInt32*)ptr = swap32(size);
						ptr+=4;
						
						while(size){
							
							if(errNone == VFSFileRead(file, size, ptr, &read) && read != 0){
								
								size -= read;
								ptr += read;
							}
							else{
								
								MemChunkFree(kernel);
								kernel = NULL;
								ErrAlertCustom(0, "Failed to read", NULL, NULL);
								break;
							}
						}
					}
				else
					ErrAlertCustom(0, "Failed to alloc", NULL, NULL);
				}
				else
					ErrAlertCustom(0, "Failed to get file size", NULL, NULL);
				
				VFSFileClose(file);
			}
			else
				ErrAlertCustom(0, "Failed to find the file", NULL, NULL);
		}
		else
			break;
	}
	
	return kernel;
}


UInt32 PilotMain(UInt16 cmd,void* cmdPBP, UInt16 flags){

	
	if(cmd == 0){
		
		MemHandle mh;
		void* image;
		
		
		image = loadImage();
		if(image){
			mh = DmGet1Resource('armc',1);
			if(mh){
				
				FrmCustomAlert(10024, "image read. loading\n", NULL, NULL);
				PceNativeCall(MemHandleLock(mh), image);
				MemHandleUnlock(mh);
				DmReleaseResource(mh);
				
				ErrAlertCustom(0, ", bailing out.", "If you're seeing this, something went terribly wrong in the ARM part of the loader", NULL);
			}
			else
				ErrAlertCustom(0, ", bailing out.", "Failed to find arm part of the loader", NULL);
			MemChunkFree(image);
		}
		else
			ErrAlertCustom(0,", bailing out.", " Failed to load image from card", NULL);
	}
	return 0;
}